"Terminal Interface for Models RCM301-303" by VigiMech Corporation
The story headline is "A multi-platform program".
The story genre is "Application".
The story description is "A text terminal interface for interacting with your model RCM301-303 mechanical labour bot."
The story creation year is 2018.

Include Menus by Emily Short.

Use undo prevention. 

Chapter - Glulx effects

[Slightly bigger, especially for the online version.]

Include Glulx Text Effects by Emily Short.

Table of User Styles (continued)
style name	relative size
normal-style	1
fixed-letter-spacing-style	1
italic-style	1
bold-style	1
alert-style	1
note-style	1
blockquote-style	1
input-style	1


Chapter - Preliminaries

Section - Weight

A thing has a number called the weight. The weight of a thing is usually 10.

Section - Toxicity

A room has a number called the toxicity. The toxicity of a room is usually 0.

To decide whether (place - a room) is toxic:
	if toxicity of place is 0:
		decide no;
	decide yes.

To decide whether (place - a room) is safe:
	if place is toxic:
		decide no;
	decide yes.

Every turn (this is the reduce toxicity rule):
	repeat with place running through rooms:
		if toxicity of place > 0:
			decrease toxicity of place by 1;
			if place is the location and lemmy talking and toxicity of place is 0:
				say "'Those green clouds are finally gone, boss.'";
			if location of the laptop is place: [this is, in fact, Alison]
				now laptop is poisoned.


Section - Smashed

[Some objects become smashed after being attacked.]

A thing can be smashed or intact. A thing is usually intact.

Section - Wet

[Some objects become wet after being in the wossname.]

A thing can be wet or dry. A thing is usually dry.

Section - Burnt

[Things become burnt by being put into the incinerator.]

A thing can be burnt or unburnt. A thing is usually unburnt.

Section - Poisoned

A thing can be poisoned or healthy. A thing is usually healthy.



Section - Tagged and Scope

[We're going to use the in-built darkness code to our advantage. All locations are dark; and we put only those things in scope which are tagged... and, crucially, the player itself.]

A thing is either tagged or not tagged. A thing is usually not tagged.

To tag (item - a thing):
	now item is tagged.

To untag (item - a thing):
	now item is not tagged.

After deciding the scope of the player:
	repeat with item running through tagged things in the location:
		place item in scope.

The can't act in the dark rule is not listed in any rulebook.

To say tag type:
	if endgame started is false:
		say "[bold type]".
		
		
Section - Mood

A mood is a kind of value. The moods are happy, gone, gloating and dead.
Lemmys mood is a mood that varies. Lemmys mood is happy.

[Lemmy starts out happy. He is dead if you manage to kill him, gone if he gets out of the mech without having secured his objective, gloating if he gets out of the mech after having secured his objective.]

[This used to be more useful, but hey.]
To decide whether Lemmy talking:
	if Lemmys mood is happy:
		decide yes;
	decide no.



Chapter - Rooms and things

Section - In front of the Lab

There is a dark room called In front of the Lab.


First-look is a truth state that varies. First-look is true.

After looking in In front of the Lab:
	if Lemmy talking:
		if turn count > 5:
			say "'[one of][unless disposable overalls has been tagged]You're moving the camera, boss, but it ain't working. No worries, Lemmy's here to tell you what he sees. [end if][or][stopping]We're standing right in front of the door, the big one that only the mech can open. No sign of the fuzz yet; but like all earthly happiness, I'm afraid that won't last[run paragraph on][one of][or]. It's like the joys of wanking, really: all too brief and a fucking mess when it's over[or][stopping][one of][verbose]. I could also wax on about the charm of these Welsh mountains and these quaint unpronounceable place names with too many l's and w's, but for once, I'll stick to the essentials. Don't get used to it, boss. It'll just be a big disappointment once [italic type]that[roman type] joy has run its course.[run paragraph on][or].[run paragraph on][stopping]'[line break][paragraph break]";
		otherwise:
			say "'The camera's spinning as if the bot's gone bloody bonkers, boss! Let me finish the story and then I'll take a good look around for you[one of][verbose]. See, I can talk fast, but I can't say two things at the same time. Not for lack of trying. [italic type]The Sun[roman type] ran this story [']bout a guy who could speed read two books at once, so I thought to myself, Lemmy, why not speed talk two simultaneous conversations? So much time saved! Spent a couple of weeks perfecting my skills, but it kept sounding like mseoamneitnhgilnegs sc rcarzayp[or][stopping].'".

Check going in In front of the Lab:
	unless noun is north or noun is up or noun is down or noun is massive door:
		say "ERROR: GPS indicates movement did not happen.[if Lemmy talking][run paragraph on][paragraph break]'[one of]Watch out, boss, you're bumping this thing into the rocks[run paragraph on][or]Ouch! There's a tree there[run paragraph on][or]Careful with the equipment, boss! We've got to open the door and go north[run paragraph on][at random]!'[line break][paragraph break][end if]" instead;
	otherwise:
		unless massive door is open:
			say "ERROR: GPS indicates movement did not happen.[if Lemmy talking and story start is not happening][run paragraph on][paragraph break]'[one of]Watch out, boss, you're bumping this thing into the door![run paragraph on][or]Ouch! You've got open the door first, boss![run paragraph on][or]Careful with the equipment, boss! We've got to open the door before going in![run paragraph on][at random]'[line break][paragraph break][end if]" instead.

Before going inside in In front of the Lab:
	try going north instead.


[The rock.]

A rock is here. The weight of the rock is 40.

Rock-examined is a truth state that varies. Rock-examined is false.

Instead of examining the rock when Lemmy talking:
	say "'It's a rock, boss[one of][verbose]. Now if I were my uncle Gary, which I'm not, and a good thing too, seeing that he has been dead these five years and hence in no state to help you in your current troubles, chief, on account of [italic type]rigor mortis[roman type] and so on, but if I [italic type]were[roman type] him, I'd fill you in on all the geology of rocks in general and of this beauty in particular. Was real passionate about that, uncle Gary was. [italic type]Loved[roman type] those rocks[or][stopping].'";
	now rock-examined is true.

Report pushing the rock when Lemmy talking:
	if rock is not in corner:
		say "Successful completion of command cannot be verified.[paragraph break]'The mech tries to push the rock, chief, but there's a big door in the way.'" instead;
	otherwise:
		say "Successful completion of command cannot be verified.[paragraph break]'Now the rock's in a different corner. More [italic type]feng shui[roman type], right?'" instead.
		
Report pulling the rock when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'The mech tries to pull the rock away, chief, but the ground's far too uneven for that. It just gets caught behind some other stones.'" instead;

Report attacking the rock when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'The mech just punched into the rock, boss. It's not impressed. The rock, I mean. Well, I s'pose the mech isn't that impressed either. It's like two statues engaged in a staring contest, you know? Could take a while.'" instead.
	

[The corner.]

A corner is here. The corner is an open container. It is fixed in place.

Instead of examining the corner when Lemmy talking:
	say "'It's just a random corner, boss[one of]. And not the one we've been painted into either[or][stopping].'[paragraph break]";
	schedule comment 3 in 2 turns.

Instead of pushing the corner when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'The claw is sort of punching lightly into the corner... if that's part of some brilliant plan, boss, I can't wait to see the rest of it!'".

Instead of pulling the corner when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'The mech is making pulling motions in mid-air. Did you perhaps activate some kind of weird test sequence?'".

Instead of attacking the corner when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break][verbose]'The claw punches the air, again and again and again! We're looking to become an arena rock act, boss? Could be a smash hit, if you ask me. [italic type]Lemmy and the Mad Mechs[roman type]. I do a mean Freddie Mercury imitation. Kind of famous for that, locally. Well, I mean, not [']locally['] in the sense that my neighbours know about it, like, my old landlady or people like that. More, you know, famous in certain [italic type]locales[roman type]. Uhm. Know what? Forget about it.'"


[The massive door.]

The massive door is north of In front of the Lab. The massive door is south of sloping hallway. The massive door is a closed openable door.

Door-examined is a truth state that varies. Door-examined is false.

Instead of examining the massive door when Lemmy talking:
	say "'The camera's now pointing straight at the door, governor[one of][verbose]. And what a door. It's a door to make other doors cry. In envy, for mercy, you name it, there's gonna be one door or another that will show that exact type of crying when confronted with this majestic piece of concrete. This door is really [italic type]there[roman type], boss. Back when the Romans ruled Britannia, people would say that doors like this had [italic type]haecceitas[roman type]. True fact. Saw it on [italic type]Eggheads[roman type] the other day[or][stopping].'[paragraph break]";
	now door-examined is true.

Massive-door-lifting is a truth state that varies. Massive-door-lifting is false.

Before opening the massive door:
	now massive-door-lifting is true.

Report opening the massive door:
	if Lemmy talking and location is In front of the Lab:
		say "'The mech is lifting the door with its arm[one of]; I can almost [italic type]hear[roman type] it strain under the weight[or]. Let's move north quickly, or it'll fall shut again[stopping].'" instead;
	otherwise if Lemmy talking:
		say "'The mech is lifting the door with its arm. We'd best move south quickly, or it'll fall shut again.'" instead.

Every turn when the massive door is open:
	if massive-door-lifting is false:
		now the massive door is closed;
		if Lemmy talking:
			say "'[one of]BANG[or]KABLAM[or]BAM[at random]! Well, the door fell closed again.'";
	now massive-door-lifting is false.

Instead of pushing the massive door when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'It's like the gates of love, boss. The harder you push, the less they budge.'".
	
Instead of pulling the massive door when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'Are you trying to pull at the door, chief? I don't think that's how it works... I think you can just [italic type]open[roman type] it?'".

Instead of attacking the massive door when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break][verbose]'Smash! Boom! Kablang! Nice combat moves, boss, but I'm afraid this door can handle a lot more than our mech can dish out[if door-examined is true]. Must be that old [italic type]haecceitas[roman type]. Positively resists non-existence, this door does[otherwise]. That's what you get for not stumping up the cash for a combat mech with lasers and rockets and stuff[end if].'".



Section - Sloping Hallway

Sloping Hallway is a dark room.

Hallway-right-direction is a truth state that varies. Hallway-right-direction is false.

After looking in Sloping Hallway:
	if Lemmy talking:
		say "'We're in a narrow hallway, boss. [one of][verbose]Well, not [italic type]that[roman type] narrow. Bigger than the one back at my flat, to be honest. Not that that's too hard, mind you, you can't hardly call my place [']spacious['] or anything, though God knows I pay Mrs. Hughes enough every month, especially given the state of the plumbing. You wouldn't believe the noises it makes at night! A bit like [']pfhlbrgggr['], but with more [italic type]menace[roman type], you know? Hard to sleep when your own shit's gurgling threats in your ear, let me tell you. Anyway... this hallway, it's sort of wide but also a bit narrow for the mech, is what I'm saying. [or][stopping]The door's to the south and the hallway itself bends to the left, so that would be[if hallway-right-direction is false]... northeast, I guess?[run paragraph on][otherwise] northwest.[run paragraph on][end if][run paragraph on][one of] No signs of the explosion here, so I'm starting to like the odds of the girl still breathing. As for stuff, only thing here's one of those [tag type]disposable overalls[roman type], but it won't fit the mech.[run paragraph on][or][stopping]'[line break][paragraph break]";
		unless endgame started is true:
			now disposable overalls is tagged.

Check going in Sloping Hallway:
	if noun is south or noun is massive door:
		unless massive door is open:
			say "ERROR: GPS indicates movement did not happen.[if Lemmy talking and story start is not happening][run paragraph on][paragraph break]'[one of]Watch out, boss, you're bumping this thing into the door![run paragraph on][or]Ouch! You've got open the door first, boss![run paragraph on][or]Careful with the equipment, boss! We'll have to open the door before going out ![run paragraph on][at random]'[paragraph break][end if]" instead.
			
Instead of going northeast in Sloping Hallway for the first time:
	now hallway-right-direction is true;
	schedule comment 1 in 1 turns;
	say "ERROR: GPS indicates movement did not happen.[if Lemmy talking][run paragraph on][paragraph break][verbose]'Ouch! Holy bejeezus, doesn't that thing know it shouldn't walk into walls? Anyway, make that northwest, boss, not northeast. Guess compass directions ain't exactly my cup of tea.'[paragraph break][end if]" instead;

Before going outside in Sloping Hallway:
	try going south instead.
	
Every turn when the player is in Sloping Hallway (this is the untag the door rule):
	if Lemmy talking:
		if SHDescriptions > 3:
			unless the player carries alison:
				if the massive door is tagged:
					say "'Uh, boss, we can't leave without Alison. That would be [italic type]inhumane[roman type]! Let me [bold type]untag the door[roman type] for a while so we can really focus on the task at hand, okay?'";
					untag the massive door.

Every turn (this is the tag the door rule):
	if Lemmy talking:
		if the player carries Alison:
			if the massive door is not tagged:
				say "'Right, we have Alison, so let me just [bold type]tag the door[roman type] again[if laptop is not burnt]. Though I still think we should dispose of the laptop first, boss. Safer that way[end if].'";
				tag the massive door.

[Disposable overalls.]
	
The disposable overalls is a thing in Sloping Hallway. The weight of disposable overalls is 1. Understand "overalls" as the disposable overalls.

Instead of examining the disposable overalls when Lemmy talking:
	say "'Looks like one of those one-size-fits-all things to me, the kind you have to put on when you're entering an OR[one of][verbose]. Actually, had to wear one of [']em myself back in, what was it, 1993? That time that Brian took a bullet in his liver and I drove him to the hospital and he was so miserable and alone that I just couldn't make myself leave his side even though I knew the pigs would be coming with a lot more questions than I could answer? Too bad he didn't make it, but at least he had a buddy by his side. Makes all the difference, it does[or][stopping].[run paragraph on][if overalls is wet] The overalls are dripping wet, on account of having been in [the wossname].[run paragraph on][end if]'[line break][paragraph break]".

Report attacking the disposable overalls when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break]'The claw just passionately smashed into the overalls, chief. Want me to make a joke about the [italic type]overall[roman type] effect being minimal?'" instead.



Section - Second Hallway

Second Hallway is a dark room. It is northwest of Sloping Hallway.

After looking in Second Hallway:
	if Lemmy talking:
		say "'The hallway continues in a straight line, boss, northwest to southeast[one of][verbose]. I suppose the lab had to be really deep inside the mountain, with the pigs now having heat detectors and so on? I preferred it back when a man could just focus on doing an honest day's work. Or a woman. Me, I'm a real feminist, chief. Not like uncle Gary. He was the worst Tory, which was kind of crazy, seeing as he never had two quid to rub together, but Tory or no, he flat-out refused to vote for the Bloody Woman on account of her being of the female persuasion[or][stopping].'".


Section - Third Hallway

Third Hallway is a dark room. It is northwest of Second Hallway.

After looking in Third Hallway:
	if Lemmy talking:
		say "'[one of][verbose]Blimey, boss, this is exciting! We can actually go [italic type]two[roman type] ways here. Do we follow the hallway northwest, or do we go off to the east, to whatever mysterious secrets may be stashed away over there? Well, maybe not that mysterious for [italic type]you[roman type], given that you designed this place. But it's my first time in the mech and I'm trying to enjoy the experience to the utmost depths of its inherent enjoyability[or]This is the exciting place where we can either follow the hall to the northwest or southeast, or enter the room to the east. I shiver in anticipation as I wait to see what you're going to choose[stopping]!'".


Section - Maintenance Room

Maintenance Room is a dark room. It is east of Third Hallway.

After looking in Maintenance Room:
	if Lemmy talking:
		say "'[one of][verbose]Sweet! There's a wotsit here for the mech! You know, a, uhm... tip of my tongue... well, a [tag type]wossname[roman type]! Like you have for your car, right, except this one's for the mech? There's a big [tag type]chain[roman type] you can pull too, which I suppose is how you can turn the thing on[or]There's [a wossname] for the mech here, boss, [if wossname is smashed]but it's broken[otherwise]with a chain for turning it on[end if][stopping]. Only exit's back west[if toxicity of Maintenance Room > 0]. Those evil clouds of green gas are still hanging around here, so let's be careful[end if].'";
		unless endgame started is true:
			now wossname is tagged;
			now chain is tagged.

[The wossname. (It's like a carwash for the mech).]

[Items that might be put into it: mech, overall, plastic barrel, 'laptop', 'alison']

The wossname is scenery in Maintenance room. It is an enterable open container. Understand "wotsit" and "whatchacallit" and "thingy" and "thingummie" and "gizmo" and "thingamajig" and "thingamabob" and "oojamaflip" as the wossname.

Rule for printing the name of the wossname:
	say "[one of]wossname[or]wotsit[or]whatchacallit[or]thingy[or]thingummie[or]gizmo[or]thingamajig[or]thingamabob[or]oojamaflip[purely at random]";

Instead of examining the wossname when Lemmy talking:
	say "'One of those things, you know?'".

Instead of attacking the wossname:
	if wossname is intact:
		now wossname is smashed;
		if Lemmy talking:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'What? Boss, you just smashed [the wossname], bending all the pipes and brushes and so on! That's a fucking tragedy, chief! I know you didn't do it on purpose, but really, this breaks my heart. Let's move back to the hallway. I don't want to dwell on this.'";
		otherwise:
			say "Successful completion of command cannot be verified.";
	otherwise:
		if Lemmy talking:
			say "Successful completion of command cannot be verified.[paragraph break]'You know, I'm not watching this. Like watching someone rip up an original Colin Bell shirt.'";
		otherwise:
			say "Successful completion of command cannot be verified.";

Check entering the wossname:
	if barrel is in wossname:
		if Lemmy talking:
			say "Successful completion of command cannot be verified.[paragraph break]'The mech doesn't fit in, boss, on account of the barrel already being inside.'";
		otherwise:
			say "Successful completion of command cannot be verified.";
		rule fails;
	if the player carries the barrel:
		if Lemmy talking:
			say "Successful completion of command cannot be verified.[paragraph break]'The mech doesn't fit in, boss, on account of carrying the big barrel.'";
		otherwise:
			say "Successful completion of command cannot be verified.";
		rule fails.

Before inserting laptop into wossname:
	if Alison is alive:
		if Lemmy talking:
			if Alison-running is true:
				say "Object put down. Successful completion of command cannot be verified.[paragraph break][verbose]'No, don't put... oh no, the laptop is rolling away again!'";
			otherwise:
				say "Object put down. Successful completion of command cannot be verified.[paragraph break][verbose]'Oh shit, the mech dropped the laptop... and now it's running away! I mean, uh, it's [italic type]driving away[roman type]. Yeah, that's it -- for some weird reason Alison has tied her laptop to an automatic vacuum bot that we apparently bumped out of its standby state. We need to go after it!'";
		otherwise:
			say "Object put down. Successful completion of command cannot be verified.";
		now Alison-running is true;
		move laptop to Third Hallway;
		rule fails.

Before dropping laptop when player is in the wossname:
	if Alison is alive:
		if Lemmy talking:
			if Alison-running is true:
				say "Object put down. Successful completion of command cannot be verified.[paragraph break][verbose]'No, don't put... oh no, the laptop is rolling away again!'";
			otherwise:
				say "Object put down. Successful completion of command cannot be verified.[paragraph break][verbose]'Oh shit, the mech dropped the laptop... and now it's running away! I mean, uh, it's [italic type]driving away[roman type]. Yeah, that's it -- for some weird reason Alison has tied her laptop to an automatic vacuum bot that we apparently bumped out of its standby state. We need to go after it!'";
		otherwise:
			say "Object put down. Successful completion of command cannot be verified.";
		now Alison-running is true;
		move laptop to Third Hallway;
		rule fails.	

[The chain]

The chain is scenery in Maintenance room.

Instead of examining the chain when Lemmy talking:
	say "'It's a big metal chain, governor. For pulling once you have entered [the wossname].'".

Washes is a number that varies. Washes is 0.

Chain-swinging is a number that varies. Chain-swinging is 0.

Instead of pushing or attacking the chain when Lemmy talking:
	now chain-swinging is 4;
	say "Successful completion of command cannot be verified.[paragraph break]'Okay... now the chain is swinging wildly back and forth. With the camera not working, we might need to wait a bit before the mech can find it again.'".
	
Every turn when chain-swinging is not 0:
	decrease chain-swinging by 1;
	if chain-swinging is 0 and location is Maintenance room and Lemmy talking:
		say "'The chain's hanging still again, boss.'".

Before pulling the chain when chain-swinging is not 0:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break]'Whoops, the chain was just a little bit off to the [one of]right[or]left[purely at random] when the mech tried to grab it.'";
	otherwise:
		say "Successful completion of command cannot be verified.";
	stop the action.

Instead of taking the chain:
	try pulling the chain.

Instead of pulling the chain:
	if player carries at least one thing:
		say "ERROR: claw not empty.";
	otherwise:
		if wossname is smashed:
			if Lemmy talking:
				say "Successful completion of command cannot be verified.[paragraph break][verbose]'It's broken, boss, and won't ever work again. Makes my cry, that. Not too proud to admit it. Just makes me cry.'";
			otherwise:
				say "Successful completion of command cannot be verified.";
		otherwise:
			say "Successful completion of command cannot be verified.[paragraph break]";
			if player is in wossname and Lemmy talking:
				if washes is:
					-- 0: say "[verbose]'Yeah! You know, boss, my car isn't much to look at -- old Ford Fiesta, in case you're just dying to know -- but even so, I treat myself to [italic type]this[roman type] every few weeks. You know, just sitting back and relaxing while the big brushes roll all around you and torrents of water stream down the windscreen... safe and sound, your own little space, not a care in the world. And [italic type]this[roman type] is even better, with my face so close and the big window all around me. Ooh, it's even going to do the wax thing! Some first class machinery you've installed here, boss! And this mech is as clean as it'll ever be.'[paragraph break]";
					-- 1: say "'Can't get enough of it? You're absolutely right! I'll just kick back and enjoy it once more.'[paragraph break]";
					-- otherwise: say "[verbose]'Now there is such a thing as overindulgence, chief. Something as glorious as this should be special, not part of a daily routine. Takes away the... uhm... the [italic type]numinosity[roman type], that's what it's called. Numinosity. Look it up.'[paragraph break]";
				increase washes by 1;
			if overalls is in wossname:
				now overalls is wet;
				if Lemmy talking and player is not in wossname and barrel is not in wossname and laptop is not in wossname and alison is not in wossname: [we don't describe the overall if there's something more important in the wotsit]
					say "'The overalls arenow soaking wet.'[paragraph break]";
			if barrel is in wossname: [the barrel cannot be in the wossname when the player is]
				if barrel is intact and Lemmy talking:
					say "'The barrel's all cleaned up, but I s'pose the water couldn't reach inside. Good thing too!'[paragraph break]";
				otherwise:
					if Lemmy talking:
						say "[verbose]'Whoa! Some of the water got into the barrel, boss, through those holes you punched; and now there's clouds of awfully green smoke coming out. Mighty impressive -- God sure didn't skimp on the special effects budget! But, uh, we probably should be extra careful around here now. Might be toxic.'[paragraph break]";
					now toxicity of the location is 6;
			if laptop is in wossname:
				now laptop is wet;
				if Lemmy talking:
					say "[verbose]'As for the, uhm, laptop... well, I suppose getting it all wet [italic type]might[roman type] be a way of destroying the data? But I think we should be going for a more final solution!'[paragraph break]";
			if Alison is in wossname:
				now Alison is wet;
				if Lemmy talking:
					say "'That shower didn't wake up Alison, boss. Better not try that again! She might, uh, drown or something?'[paragraph break]";
			if no things are in the wossname:
				if Lemmy talking:
					say "'Yeah, okay, it's working. But what's the sense of using [the wossname] if the mech isn't inside?'".





Section - Fourth Hallway

Fourth Hallway is a dark room. It is northwest of Third Hallway.

After looking in Fourth Hallway:
	if Lemmy talking:
		say "'[one of]Even more hallway! But there's a big room to the north that would appear to be full of [italic type]things[roman type], chief. Like crates and stuff[or]We're at the northwest end of the corridor, boss. Big hall's to the north[stopping].'".

Section - South Hall

South Hall is a dark room. South Hall is north of Fourth Hallway.

SHDescriptions is a number that varies. SHDescriptions is 0.
DoneTheDescribe is a truth state that varies. DoneTheDescribe is false.

After looking in South Hall:
	if Lemmy talking:
		do the SHDescribe.
		
To do the SHDescribe:
	say "'[if SHDescriptions is 0][verbose]Bloody hell! The explosion really shook things up here! It's a big, big mess, boss. I'll need a minute to get my bearings before I can faithfully fill you in on the details[otherwise if SHDescriptions  is 1][verbose]Let's consider what we're here for, boss. Way I see it, two things we need to do. One, find the laptop on which Alison keeps all her recipes and stuff, and destroy it. If the coppers get their paws on it, they'll put us all in the bin for a long, long time. And if Harry's boys grab it, well, they'll take the recipes and send the rest on to the pigs anyway. So that's goal number one: destroy the laptop[otherwise if SHDescriptions is 2]Goal number two, we should find Alison! Need to get her out before there's another explosion. Basic human decency, innit? Course it is. You always say to me, Lemmy, you say, Lemmy, if there's one person out there in this cynical backstabbing world that I can trust, Lemmy, it's gotta be you. And I'm smack in the middle of proving you right, chief[otherwise if SHDescriptions is 3][verbose]Let's see. There are boxes here, filled with chemicals, machinery, bags of our beautiful ice. And here's one with, uh, with Baxters soup cans? Okay, sure, I suppose Alison has to eat too... but seriously, [']Root Vegetable and Turmeric[']? Sounds like an ancient Chinese torture method to me[otherwise if SHDescriptions is 4][verbose]Soup can torture... man, those chinks really are creative that way. That and buying up London, s'what they're good at. But they don't have what I would call [italic type]culture[roman type]. I mean, who's the Chinese Shakespeare? Is there Night of the Proms in Shanghai? Don't think so! Anyway, this room is pretty big. It goes on to the north, but we can't go there quite yet, since there's a big [tag type]plastic barrel[roman type] in the way. No sign of the laptop or Alison here[otherwise if SHDescriptions is 5]I could talk all day about those soup cans, chief, but we're in a hurry, so I won't. We can go south, back to the corridor, or north, towards the rest of the lab[end if].'";
	if SHDescriptions is 4:
		now plastic barrel is tagged;
	unless SHDescriptions is 5:
		increase SHDescriptions by 1;
	now DoneTheDescribe is true.
		
Every turn when player is in South Hall:
	unless DoneTheDescribe is true:
		if SHDescriptions is not 5:
			do the SHDescribe;
	now DoneTheDescribe is false.
		
[The plastic barrel.]

The plastic barrel is in South Hall. The weight of the plastic barrel is 186.

Instead of examining the barrel when Lemmy talking:
	say "'It's a big thing, the size of one of those old style water barrels. [one of][verbose]You know, the ones that they wear in cartoons when they're flat broke and can't buy any clothes? [or][stopping]Made of blue plastic[if barrel is smashed] and with some holes through which I see greenish powder[end if]. Probably dangerous stuff, with all those big skulls painted on. Better not mix it with the soup, s'all I'm saying. Though it might count as a mercy killing, after that turmeric.'".
	
Instead of pushing the barrel when the barrel is in South Hall:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break]'There's too much stuff here, boss. You're just pushing the barrel against a stack of crates that ain't gonna move.'";
	otherwise:
		say "Successful completion of command cannot be verified.".
		
Instead of pulling the barrel when the barrel is in South Hall:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break]'There's too much stuff here, boss. You'll have to pick it up first.'";
	otherwise:
		say "Successful completion of command cannot be verified.".
		
[Dropping the barrel]

Report dropping the barrel when the player is in South Hall:
	if Lemmy talking:
		say "Object put down.[paragraph break]'Okay... restoring the [italic type]status quo[roman type], s'what that's called.'";
	otherwise:
		say "Object put down.";
	rule succeeds.

[Opening the barrel shouldn't work.]

Instead of opening the barrel:
	if Lemmy talking:
		say "ERROR: command inconsistent with spatial model.[paragraph break][verbose]'Don't think the mech can handle that, boss. There's some of those things that do [']click['] first, and then the mech would have to hold the barrel in one claw while using another claw turn the lid around... since you got the cheap version with only one arm, that ain't happening.'";
	otherwise:
		say "ERROR: command inconsistent with spatial model.".

[Can't move north when the barrel is here.]

Before going north in South Hall:
	if plastic barrel is in South Hall and plastic barrel is not held:
		if Lemmy talking and SHDescriptions > 3:
			say "ERROR: GPS indicates movement did not happen.[paragraph break]'The barrel's in the way, boss. You'll need to pick that up first.'";
		otherwise:
			say "ERROR: GPS indicates movement did not happen.";
		rule fails;
		
[Attacking the barrel]

Instead of attacking the barrel:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break][verbose]'The mech just punched some [if barrel is smashed]more [end if]holes into the barrel, chief. But it looks like the chemicals inside are all wrapped up in plastic bags, so only a little is spilling out. That's a good thing, right[if barrel is intact]. Evil-looking green powder, if you ask me. Hard to believe it turns into that white ice. Mysteries of our trade, eh[end if]?'";
	otherwise:
		say "Successful completion of command cannot be verified.";
	now barrel is smashed;




Section - North Hall

North Hall is a dark room. North Hall is north of South Hall.

After looking in North Hall:
	if Lemmy talking:
		say "'Not quite so many crates and boxes here, though it's all a mess [']cause of the accident. Doorways west, east and north, if I'm not mistaken. [one of]No sign of the laptop or Alison, but there's a [tag type]big red button[roman type] on the west wall[or]And a [tag type]big red button[roman type] on the west wall just [italic type]begging[roman type] for someone to press it like: [']I wonder what this does?['], and he looks up and everyone's running for their lives[or]And a [tag type]big red button[roman type] on the west wall[stopping].'";
		unless endgame started is true:
			now big red button is tagged.
		
The big red button is a thing in North Hall. It is fixed in place.

Instead of examining the big red button:
	if Lemmy talking:
		say "'What can I say? It's big, it's red, it's a button. Can be pushed. Doesn't remind me of any amusing anecdotes about my family members[one of][or]. Although, on second thoughts, I had a niece who used to ask me whether I wanted to press her little red button. [Tracey]Tracey was funny that way[or][stopping].'";

To say Tracey:
	schedule comment 4 in 6 turns.

Before attacking the big red button:
	try pushing the big red button instead.
	
Before taking the big red button:
	try pulling the big red button instead.

Instead of pulling the big red button:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break]'That looked... awkward. The mech's claw tried to get a grip on the button, but it kept sliding off, on account of the button being what one might call [']semi-spherical['].'";
	otherwise:
		say "Successful completion of command cannot be verified.".

Instead of pushing the big red button:
	if Lemmy talking:
		if alison is not in incinerator unit:
			say "Successful completion of command cannot be verified.[paragraph break]'[one of][verbose]Whoah! A huge column of fire just flamed up in the room to the west. I'll say, that's one industrial strength incinerator[or]The incinerator just flamed up again[stopping]! [if no thing is in incinerator unit]As far as I could see, nothing got burned though[otherwise]I suppose that's the last we'll see of [list of things in the incinerator unit with definite articles][end if][if barrel is in incinerator unit][verbose]. Wow, and burning that barrel full of chemicals has released some huge clouds of green smoke! Maybe we'd better not enter that room for a while, boss. Might not be safe[end if].'";
		otherwise:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'No! Nooo! You just... you just incinerated Alison! You're a fucking psycho! You're... you're a bloody cunt, that's what you are! Such a great plan, but you had to come and ruin my life once again... Fuck, I'm out of here. I'm gonna leave this mech and I'm gonna make damn sure you can't do shit with it any more, boss. Bloody cunt! [bold type]Untag all[roman type].'";
			now lemmys mood is gone;
			do the great untag;
	otherwise:
		say "Successful completion of command cannot be verified.";
	repeat with item running through things in incinerator unit:
		now item is burnt;
		if item is barrel:
			now toxicity of Incinerator Room is 70;
		remove item from play;


Section - Bedroom

Bedroom is a dark room. Bedroom is east of North Hall.

After looking in Bedroom:
	if Lemmy talking:
		say "'This must be where Alison lives. [one of][verbose] Pretty strange phrase, when you think about it. [']Where do you live?['] [']Right where I stand, arsehole, or are you talking to dead people?['] So I guess what I ought to say is, this is her bedroom. And whoah, chief, look, there's the [bold type]laptop[roman type]! Give it a good hard [italic type]punch[roman type], boss! We need to really smash it to pieces[or]The only way out is back west[stopping].'";
		if laptop is in Bedroom and Alison-running is false:
			now laptop is tagged.

[The laptop]

The laptop is in the bedroom. The weight of the laptop is 73. [This is actually alison.]

Alison-running is a truth state that varies. Alison-running is false. [can be true even when alison is dead!]

To decide whether Alison is alive:
	if laptop is smashed:
		decide no;
	if laptop is burnt:
		decide no;
	if laptop is poisoned:
		decide no;
	decide yes.

Instead of examining the laptop:
	if Lemmy talking:
		if Alison-running is true and Alison is alive and the player does not carry the laptop:
			say "[verbose]'It's a weird sight, boss, but the laptop's been mounted on one of these annoying vacuum bots, and its constantly moving about. You'll have to grab or punch it immediately after I've tagged it, or we'll lose sight of it again.'";
		otherwise if laptop is smashed:
			say "'It's pretty smashed up, boss, but I think we ought to destroy it in a more radical fashion.'";
		otherwise:
			say "[verbose]'Here it is, boss, the laptop with all the compromising stuff on it. Recipes, data, shipments, everything. Very methodical, that Alison -- not like me at all. If the pigs ever bust my place, they won't find nothing that could endanger you, boss. I'm like the poster boy for opsec, I am. See, [italic type]I[roman type] can't even find anything in my flat!'".

Instead of attacking the laptop:
	if Lemmy talking:
		if laptop is intact:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Ouch! Uhm, yeah, the laptop is broken good and proper, boss. Lots of little bits scattered on the ground and, you know, vital fluids leaking out and suchlike. Kinda hurts me a little bit, seeing good technology go to waste like that. But, uh, maybe we should dispose of it in a more permanent fashion? Never know whether the pigs might still be able to get some stuff off of it.'";
		otherwise:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Okay, okay, we smash it some more, I get it. Look, the laptop didn't do anything wrong, right? Let's handle it with just a little respect and send it off to laptop Heaven or wherever good machines end up going. Jeez.'";
	otherwise:
		say "Successful completion of command cannot be verified.";
	now laptop is smashed;

Instead of pushing or pulling the laptop:
	if Lemmy talking:
		if alison is alive and alison-running is true:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Shit, we didn't get a good grab on the laptop, boss.'";
		if alison is alive and alison-running is false:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Shit, no, the mech touched the laptop, but didn't really grab it! Now it's all woken up and running away! I mean, uh, [italic type]driving away[roman type]. Yeah, that's it -- now that I look more closely, I see that the laptop's been tied to an automatic vacuum bot that we bumped out of its standby state. We need to go after it right now!'";
			now alison-running is true;
			now Alison-spotted is true;
		unless alison is alive:
			say "Successful completion of command cannot be verified.[paragraph break]'The mech is just prodding the laptop a bit, boss. I think we should pick it up and destroy it for good.'";	
	otherwise:
		say "Successful completion of command cannot be verified.";

Report dropping the laptop when Alison-running is true and Alison is alive:
	say "Object put down.[paragraph break]'Don't drop the lap... oh no, it's escaped again!'";
	rule succeeds.

Report dropping the laptop when Alison-running is false and Alison is alive:
	if Lemmy talking:
		say "Object put down.[paragraph break][verbose]'Oh shit, the mech dropped the laptop... and now it's running away! I mean, uh, [italic type]driving away[roman type]. Yeah, that's it -- now that I look more closely, I see that the laptop's been tied to an automatic vacuum bot that we bumped out of its standby state. We need to go after it right now!'";
	otherwise:
		say "Object put down.";
	now Alison-running is true;
	now Alison-spotted is true;
	rule succeeds.

Alison-spotted is a truth state that varies. Alison-spotted is false.

Every turn (this is the spot Alison rule):
	if laptop is in the location and Alison-running is true and Lemmy talking and Alison-spotted is false:
		say "'Boss, there's [bold type]the laptop[roman type]! Give it a good punch!'";
		now laptop is tagged;
		now Alison-spotted is true;
	otherwise:
		now Alison-spotted is false.


Last every turn (this is the Alison moves rule):
	if Alison-spotted is false:
		if Alison-running is true and Alison is alive and the player does not carry the laptop:
			if the laptop is in a room (called the current space):
				if current space is not In front of the lab:
					if the player is in current space or a random chance of 1 in 3 succeeds:
						let next space be a random room which is adjacent to the current space;
						unless next space is In front of the Lab:
							unless toxicity of next space > 0:
								unless player is in next space:
									move laptop to next space;
									now laptop is not tagged;
									if current space is the location and Lemmy talking:
										let way be the best route from current space to next space;
										say "'Damn, boss, I saw the laptop rolling away to the [way].'";
				otherwise:
					remove laptop from play;
					if current space is the location and Lemmy talking:
						say "Damn, the laptop rolled away into the woods! We'll never see it again.".
						


Section - Incinerator Room

Incinerator Room is a dark room. It is west of North Hall.

After looking in Incinerator Room:
	if Lemmy talking:
		say "'Not much here, boss. Just [one of]a[or]the[stopping] big metal [tag type]incinerator unit[roman type][one of][verbose]. And no, I'm not making that name up. There's a label on the side, with some warnings about not putting children and pets in it... comes from across the pond, right? Otherwise it's mostly just a fairly large hole that you can put stuff into[or][stopping]. Only way back out's east[if toxicity of Incinerator Room > 0]. The green gas is still thick here, so we'd better get out[end if].'";
		unless endgame started is true:
			now incinerator unit is tagged.

The incinerator unit is in the Incinerator Room. It is an open container. It is fixed in place.

Instead of examining the incinerator unit:
	if Lemmy talking:
		say "[verbose]'It's mostly just a hole, boss. You can put stuff in it and then you probably need to push the red button in the other room. Just between you and me, boss, I suspect that it's then going to [italic type]incinerate[roman type] whatever you put inside. Wild guess, but I have my moments.'".
		
Report inserting the laptop into the incinerator unit:
	if Lemmy talking:
		say "Object put down. Successful completion of command cannot be verified.[paragraph break]'Good thinking, boss!'";
	otherwise:
		say "Object put down. Successful completion of command cannot be verified.";
	rule succeeds.
	
Report inserting Alison into the incinerator unit:
	if Lemmy talking:
		say "Object put down. Successful completion of command cannot be verified.[paragraph break][verbose]'What the hell are you doing, boss? If that's supposed to be a joke, it ain't funny at all. Pick her up again!'";
	otherwise:
		say "Object put down. Successful completion of command cannot be verified.";
	rule succeeds.

Section  - Laboratory

Laboratory is a dark room. It is north of North Hall.

After looking in Laboratory:
	if Lemmy talking:
		say "'Now [italic type]this[roman type] must have been where the explosion took place, guv. There's like smashed glass everywhere, toppled machines, puddles of weirdly coloured liquids, live wires cut clean through, producing dramatic showers of sparks -- you know, the works[one of][verbose]! I hope you're not going to put me on the clean-up crew, that's for certain. Hey, at least this time it wasn't me that made the mess, right? And look, over here, it's [bold type]Alison[roman type]! Knocked out stone cold, if I'm any judge. But not that much blood or anything... if we get her outside soon, before there's another explosion, she'll make it just fine[or][stopping].'";
		if Alison is in laboratory:
			now Alison is tagged.

[Alison]

Alison is in the laboratory. Alison is a woman. The weight of Alison is 5. [This is actually the laptop.]

Instead of examining Alison:
	if Lemmy talking:
		say "'She's looking fine, boss, though she might need a new lab coat. And perhaps a short holiday in the Cotswolds or somewhere, to get over the shock.'".

Report taking Alison when Lemmy talking:
	say "Object picked up.[paragraph break][verbose]'Good work, boss[one of]! You know, this machine is surprisingly gentle. I mean, that big claw, it could probably crush her to goo if it wanted to. But it's holding her real tenderlike. Let's be extra careful as we carry the lady outside[or][stopping]!'";
	rule succeeds.

Instead of pushing or pulling Alison:
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break][verbose]'Uh, chief, you shouldn't move an injured person more than is necessary. First rule of first aid! I know because I took a first aid course back when I coached the junior teams at the local football club. Not a great experience, to be honest. Parents just don't know how to raise their kids anymore; [']'fraid of using the belt, that's what they are. I sure got taught some manners that way! Once stole some money from the Salvation Army, not much, maybe two or three quid, tops, but when dad found out, he made sure I couldn't sit for a week. Saved me from a life of crime, it did. Well, figuratively speaking.'";	
	otherwise:
		say "Successful completion of command cannot be verified.";

Report dropping Alison when Lemmy talking:
	unless the location is In front of the lab:
		say "Object put down.[paragraph break][verbose]'Gently, gently... yes, that's fine[one of]. I hope this thing won't accidentally step on her, so fingers crossed that these VigiMech guys know what they're doing. I mean, what kind of name is that for a company? Is that [']vigi['] as in, like, [']vigilante[']? Makes no sense. Although I'll admit that [']vigilante['] is a good word. Did you ever realise, chief, that [']vigilante['] is the same letters as [']genitival['], meaning [']pertaining to the organs of reproduction[']? Funny, eh? All the world's knowledge is stored away inside this little brain, boss. The useless part of it, anyway. As for the rest, you can find it on Wikipedia, so why bother? That's what a smartphone's for[or][stopping].'";
		rule succeeds.

Instead of attacking Alison when Lemmy talking:
	say "Successful completion of command cannot be verified.[paragraph break][verbose]'[one of]Boss, be careful! You can't hit a lady! It's a good thing this mech doesn't hit [italic type]that[roman type] hard... let's get Alison outside and give her some help.[run paragraph on][or]Stop that, boss! Just carry her outside! God, I can't watch this...[run paragraph on][stopping]'[line break][paragraph break]";


Chapter - The story

Section - Initial interactions

Story start is a scene. Story start begins when Entire Game begins. Story start ends when rock-moving ends.[This is the container scene for the next bunch.]
Exposition is a scene. Exposition begins when Story start begins. Exposition ends when rock is tagged for the first time.
Rock-taking is a scene. Rock-taking begins when Exposition ends. Rock-taking ends when the player has the rock.
Rock-dropping is a scene. Rock-dropping begins when Rock-taking ends. Rock-dropping ends when the corner is tagged.
Rock-moving is a scene. Rock-moving begins when Rock-dropping ends. Rock-moving ends when the rock is in the corner.


First after looking for the first time:
	now game-started is true;
	if Lemmy talking:
		say "[verbose]'Good to see you coming online, boss! Don't worry, I've got this. Like you always say -- [']Lemmy, sweet Lemmy, my dearest pal, where would I be without you?['] Can't rightly say, chief; but right now, let me tell you where you are: in deep. We'll scrape through, though. Don't worry.'";
		now verbosity is 1.

Introduction counter is a number that varies. Introduction counter is 0.

To decide whether introduction spoken:
	if Story start is happening and verbosity is not 2:
		decide yes;
	otherwise:
		decide no.

Every turn when introduction counter is 0 and introduction spoken:
	if Lemmy talking:
		say "[verbose]'So here's the story. There's been a god-almighty explosion down in the lab. Alison mixed some new stuff together and it went wrong, I suppose? Always experimenting, that girl; just can't be content with what she has. Never satisfied. Tragic, really. Went to Oxford and all those fancy places, but when you come right down to it, it did her bugger-all good!'";
		increase introduction counter by 1.

[One turn during which the player can catch their breath.]

Every turn when introduction counter is 1 and introduction spoken:
	if Lemmy talking:
		say "[verbose]'Anyway, the bang was loud enough to have been heard all the way back in Birmingham, so I expect Her Majesty's finest will be coming around for a chat and a nice cup o['] tea sometime soon. Unless Harry's boys get here first, which would be worse. Either way, we'd better get going.'";
		increase introduction counter by 1.
	
Every turn when introduction counter is 2 and introduction spoken:
	if Lemmy talking:
		say "[verbose]'The bad news is that the mech got damaged when the lab blew. Not badly, this passenger compartment's still pretty comfy, but it looks like the camera got smashed by a freak stone. Makes it hard for you to navigate, right? But there's also good news: Lemmy's here to save the day! I'll just lean back in this seat and [']tag['] anything important, while you order the bot around. A fail-safe plan, can't go wrong.'";
		increase introduction counter by 1.

Every turn when introduction counter is 3 and introduction spoken:
	if Lemmy talking:
		say "[verbose]'So let me tag this bloody big [bold type]rock[roman type] that's blocking the door. Go and pick it up, chief!'";
		now the rock is tagged;
		increase introduction counter by 1.

Every turn during rock-taking:
	if remainder after dividing turn count by 5 is 0:
		if Lemmy talking:
			if introduction counter is 5:
				say "'[one of]We're in a bit of a hurry, chief. Just take the rock[or]Take the rock, boss[stopping]!'";
			otherwise:
				now introduction counter is 5.

Report taking the rock for the first time:
	if Lemmy talking:
		say "[verbose]Object picked up.[paragraph break]'Great! That's first class honours in rock picking for us, chief. But we don't really need that rock[if rock-examined is true] -- not like my uncle Gary would have needed it, may he rest in peace -- [otherwise], [end if]so let's [italic type]drop[roman type] it again.'" instead;
	otherwise:
		say "Object picked up." instead.

Every turn during rock-dropping:
	let temp be time since rock-dropping began;
	let ntemp be temp divided by 1 minute;
	if lemmy talking and remainder after dividing ntemp by 10 is 9:
		say "'[one of]We're in a bit of a hurry, chief. Just drop the rock[or]Drop the rock, chief[stopping]!'"

Report dropping the rock during rock-dropping:
	now corner is tagged;
	if lemmy talking:
		say "[verbose]Object put down.[paragraph break]'Okay... it was a good plan in the abstract, but [italic type]in concreto[roman type] -- term from Roman architecture, boss, occasional passion of mine -- [italic type]in concreto[roman type] the mech dropped the rock right in front of the door again. Meaning we still can't go in. So... what I'll do is, I'll tag that [bold type]corner[roman type] over there, and you can pick up the rock and put it in the corner. That's lateral thinking, that is.'" instead;
	otherwise:
		say "Object put down." instead.

Every turn during rock-moving:
	let temp be time since rock-moving began;
	let ntemp be temp divided by 1 minute;
	if lemmy talking and remainder after dividing ntemp by 10 is 9:
		say "'[one of]We're in a bit of a hurry, chief. Just put the rock in the corner[or]Put the rock in the corner, chief[stopping]!'"
	
Report inserting the rock into the corner:
	do nothing instead.

When story start ends:
	now the rock is not tagged;
	now the corner is not tagged;
	now the massive door is tagged;
	if Lemmy talking:
		say "[verbose]'Great! Now let's try this [']untag['] button... okay, I think I've just [bold type]untagged the rock and the corner[roman type]. Should keep us focused on the task at hand, right, boss? Remember that time when I was to deliver some goods to that guy in Brixton and there was that other guy selling those guns for a low, low price? If you could have [italic type]untagged[roman type] those firearms, chief, I wouldn't have lost the goods and you... well, shouldn't bring [italic type]that[roman type] up at a happy moment like this, I guess, but a lot of trouble saved for both of us, that's for certain. Anyway, listen to me ramble on and on and on again when [italic type]speed[roman type] is of the essence... and I don't mean our pills either, boss, but your good old-fashioned kinetic velocity. So what I'll do, is, I'll tag the [bold type]massive door[roman type] so we can go and head north.'"

Section - If Lemmy dead and Alison alive

Every turn (this is the Alison can speak rule):
	if Lemmys mood is dead:
		if Alison is alive:
			if laptop is enclosed by a room:
				if toxicity of the location is 0:
					if a random chance of 1 in 6 succeeds:
						remove laptop from play;
						say "[one of]'Is he... yes, quite dead. Boss, can you hear me? I believe congratulations are in order for getting rid of that creepy little jerk. Anyway, this place is clearly compromised. I'll leave through the emergency exit. Hide a bit, make sure nobody's on my tail. See you later, boss. Better increase my paycheck, too. This is turning out to be way more dangerous than I bargained for.'[or][stopping]".

Section - Starting the end game / minor untagging

Endgame started is a truth state that varies. Endgame started is false.
Endgame countdown is a number that varies. Endgame countdown is 1.

Every turn (this is the start the end game rule):
	if endgame started is false:
		if laptop is burnt:
			if player carries alison:
				if Lemmy talking:
					if Endgame countdown is 0:
						say "[verbose]'Things are going swimmingly, boss! Weird expression, really. [']How's the boat holding up in the storm, captain?['] [']Well, laddie, things are going quite swimmingly.['] Not what I would call reassuring. But for us, boss, things couldn't be better: we've disposed of the laptop [italic type]and[roman type] we're ready to carry Alison out of the lab. I'll just [bold type]untag[roman type] all the things we won't need going forward; no use wasting time on them, right?'";
						do the minor untag;
						now endgame started is true;
					otherwise:
						decrease endgame countdown by 1.

To do the minor untag:
	untag laptop;
	untag corner;
	untag wossname;
	untag overalls;
	untag chain;
	untag barrel;
	untag button;
	untag incinerator unit.
	


Section - Final interactions

Every turn (this is the Lemmy opens up rule):
	if the location is Sloping Hallway and the player carries Alison:
		if Lemmy talking:
			say "[one of][verbose]'Well, boss, I've really done it, haven't I? I've completely earned back your trust, right? You know, after that unfortunate accident with the shipment in Brixton, when you had those two big guys break my left arm as a [']final warning['] before my [']last chance['], you know what I said to myself? Lemmy, I said, Lemmy, don't be mad. You failed the boss, it's all your own fault. This is your last chance, Lemmy, your final opportunity. So you've got to [italic type]make it good[roman type]. You've got to impress the heck out of the chief. And I did, right? Here we are, just the two of us, carrying Alison[if laptop is burnt or laptop is smashed], having destroyed all the incriminating information[end if], a few short steps away from a happy ending. That's who I've always been, from the early days, remember? Your loyal goon, boss; your best pal; your one and only Lemmy. Faithful till the end, just like Lassie. I loved that show when I was a kid, you know. Loved it. Made friends with all the kids who owned tellies just so I could watch every episode.'[or][stopping]";

Every turn (this is the Lemmy asks to drop Alison rule):
	if the location is In front of the Lab and the player carries Alison:
		if Lemmy talking:
			say "[one of][verbose]'Fantastic! Now you just [italic type]drop[roman type] Alison-- don't worry, the mech is pretty careful -- and I'll get out of this thing and see how she can be patched up.'[or][or][or][or][or][or]'Come on, what are you waiting for? Drop Alison!'[or][or][or][or][or][or]'Put her down, chief. I need to check whether she is okay.'[or][or][or][or][or][or]'Drop the lady, chief!'[stopping]"

Every turn (this is the start gloating rule):
	if the location is In front of the Lab and Alison is in the location:
		unless the player carries Alison:
			if Lemmy talking and Lemmys mood is not gloating:
				say "[verbose]'Yes, yes, yes, yes, YES! I've done it! I'm a genius, a geezer to eclipse all geezers! Oh god, this is the best day of my life. Thank you for everything, boss. Thank you for steering the mech and thank you for being the stupidest turd in the history of stupid turddom. Yes, yes, YES! Okay, step one, [bold type]untag all[roman type]. Oooh, your big mech doesn't work if Lemmy doesn't want it to. Feeling a bit helpless, boss? A bit pushed around? Welcome to the club. Heheh. Step two: getting out of this piece of crap... just like this.'";
				do the great untag;
				now Lemmys mood is gloating.

Gloating counter is a number that varies. Gloating counter is 0.

Every turn when Lemmys mood is gloating:
	if gloating counter is 1:
		say "'Step three: gloating! It was all so easy, almost [italic type]too[roman type] easy. Was expecting a bit more of you, boss. You ate it all up! Explosion? There never was no explosion! Alison's much too careful for that. All that happened is, I put a bit of duct tape on the camera of the mech. Just a little duct tape, and lo and behold, this five million quid machine is good for fuck-all and it's little Lemmy, little, dispensable, disposable Lemmy, who has to come in and save you. God, to have to stoop to tricks like that, after twenty years of putting my arse on the line for you. Makes a man doubt the honesty of the world, it does. Breeds despair in the soul. If I ever kill myself, it will be your fault, boss.'";
	if gloating counter is 2:
		say "'Anyway, the rest was simple. As soon as I saw the laptop, I tagged it [']Alison['] and I knew you'd take it right out of the lab for me. I've got them in my hands right now, boss, your secrets, all of them or near enough as makes no difference. Harry's gonna pay me real good for this. Real good. I'm going to buy me a little house of my own down in Torquay or Paignton and then I'll retire. Good plumbing and a bit of nice weather, that's all that a man like me really wants at this stage of life. Maybe a second-hand Volkswagen. You know me, boss -- deep down, I'm a simple lad with simple tastes. Never had no airs.'";
	if gloating counter is 3:
		say "'[if Alison is alive]As for Alison... well, Harry was going to pay me extra if I got her killed, so I guess that's some money I'll never be seeing. But you know me, boss. I'm a sentimental man, prone to sudden bouts of tenderness. Sure, I hate that bitch. But, having reflected on it, I think it all worked out for the best[otherwise]As for Alison... well, she was sleeping when we entered her bedroom and then I tagged her as [']laptop[']. Not my finest hour, boss, I'll grant you that, but then Harry [italic type]did[roman type] promise me a lot of extra dosh if I managed to get rid of the woman. And a man's got to look after himself, right? I know you would have done the same thing. Always were pretty good at looking after yourself[end if].'";
	if gloating counter is 4:
		say "'So, I guess that's the end. Bit of a weird moment, too, after all those years. Makes me think back to Lemmy as a young lad, all starry-eyed, doing his first job for the boss, proud as proud could be. I love that kid. Wonder what happened to him, but, then again, think I know. Had the wrong friends. Teamed up with a cold-hearted bastard who fucked up his life. So fuck you, boss. Fuck you.'";
	if gloating counter is 5:
		say "'That's it, then. Lemmy out.'";
	if gloating counter is 11:
		say "'You still there, boss? I'm not changing my mind, you know. I'm not. Sure, we had some good times together. Watching Lassie at your place; getting all shit-faced in the park; checking out the girls. But it was too little and it was too long ago. Spent too many years living off of those memories and it just ain't working for me any more. Don't think you ever loved me. Or maybe having my arm broken was your way of telling me you still care for me? It's crossed my mind. But that's fucked up, boss. That just ain't healthy. So do like that Robert De Niro character and go see a shrink, okay? As for me, I just can't take it any longer. So this, this very sentence, this really is the last thing I'm ever saying to you. I'm going to get in my car and drive to Harry's boys and you'll never hear from me again. Okay?'";
	if gloating counter is 12:
		say "'And one other thing. You'd better get out of the country soon, chief. Harry's got some pretty high-ranking pigs in his back pocket, so the roz will be coming for you in no time. Just book the first flight you can. And take care, okay? No hard feelings.'";
	if gloating counter is 20:
		say "'Just [italic type]get on the plane[roman type], boss! I'm gone! Gone. So, go. Now. I'm off. Really!'";
	if gloating counter is 403:
		say "'That Lemmy guy, what a dumbass. He really thought we were going to pay him.'[paragraph break]'That look on his face? Priceless! Made it totally worth driving all the way out here.'";
	if gloating counter is 404:
		say "'So this is the mech they were using?'[paragraph break]'Guess so. Pretty impressive piece of hardware, actually. Wouldn't mind one of our own.'";
	if gloating counter is 405:
		say "'Hey, there's a piece of duct tape here.'[paragraph break]'Don't touch it! If you unblock the camera, he can shoot us with built-in machine guns or something.'[paragraph break]'Shit. Nasty stuff.'[paragraph break]'You bet. Pretty smart of the boss to come up with this plan, though, and then getting that Lemmy guy to actually do it.'[paragraph break]'Yeah, well, backstabbing goons are in no short supply. Ain't no loyalty in the world any more, [']s what my dad used to say. Still true.'";
	if gloating counter is 406:
		say "'Anyway, let's go back. We'll have plenty of time to explore this place later.'[paragraph break]'Yeah, and we'd better dump the body somewhere on the way out.'";
	if gloating counter < 500:
		increase gloating counter by 1.


Section - Comments and comment scheduling

[We sometimes want Lemmy to return to a topic he discussed earlier. We use scheduled comments for this; and we also make sure that he'll never do this if he he recently said something particularly verbose.]


Table of scheduled comments
ID			Schedule		Follow-up		Follow-time		Comment
1			0		2		1		"'Also... I know what you're thinking, boss. That's right, [italic type]I[roman type] know what [italic type]you[roman type] are thinking. Turns out I'm a psychopath after all, eh? No, I mean, a... a telekinetic? Point is: I can read your mind. Here's what you're thinking, boss: if compass directions ain't Lemmy's cup of tea, then what [italic type]is[roman type]? Hm? Is he an Earl Grey enthusiast? A Ceylon [italic type]aficionado[roman type]? To be frank with you, chief, I'm not that much of a tea person. I blame it on me mum, who'd make the strongest brew this side of Yorkshire and then gave us only the tiniest sip of milk to water it down with. On account of milk being more expensive than tea and us being sort of permanently a bit skint, you see.'[paragraph break]"
2			0		0		0		"'Come to think of it, could have been on account of mum's tea that dad was always straight down the pub after work. Used to be completely rat-arsed when he finally dragged himself in. Wouldn't have been nearly as skint if he'd skipped the pints... funny place, the world is. Mysterious ways and so on.'[paragraph break]"
3			0		0		0		"'That was pretty funny, wasn't it, that joke about the corner? [italic type]Not the one we've been painted into either[roman type]... hehe. Nice. Can't hear your peals of laughter, boss, but never doubt I know you're guffawing!'[paragraph break]"
4			0		0		0		"'Wonder why I never bumped uglies with Tracey? The thought probably scared the pants off of me. Except, you know, not.'[paragraph break]"

To schedule comment (identified - a number) in (count - a number) turns:
	repeat through table of scheduled comments:
		if ID entry is identified:
			now schedule entry is count.

Verbosity is a number that varies. Verbosity is 0.

To say verbose:
	now verbosity is 2.

Every turn (this is the say scheduled comments rule):
	if Lemmy talking:
		if verbosity is 0:
			let talked be false; [Max one comment per turn.]
			repeat through table of scheduled comments:
				if schedule entry is not 0 and talked is false:
					decrease schedule entry by 1;
					if schedule entry is 0:
						say comment entry;
						now talked is true;
						if follow-up entry is not 0:
							schedule comment follow-up entry in (follow-time entry + 1) turns; [it will have a higher ID, so it ge's cycled once immediately.]
						blank out the whole row;
		otherwise:
			decrease verbosity by 1.




Chapter - Tweaking Inform


Section - The banner

Rule for printing the banner text:
	say "Terminal Interface for Models RCM301-303[line break]Version 1.4.23. © 2018 VigiMech Corporation.";
	rule succeeds.
	
Section - The status line

When play begins:
	now the left hand status line is "[left status carry]";
	now the right hand status line is "[right status carry]".
	
To say left status carry:
	if player carries nothing:
		say "Held: nothing.";
	otherwise:
		let item be a random thing carried by the player;
		say "Held: [item]".
		
To say right status carry:
	if player carries nothing:
		say "";
	otherwise:
		let item be a random thing carried by the player;
		say "([weight of item] kg)".	

	
Section - Starting the game

Before looking for the first time:
	say "[line break]Welcome to the terminal interface of your model RCM302 remote-controlled mech. Unit online and ready for input.[line break][line break]For unit diagnosis, [italic type]x me[roman type]. For instructions, [italic type]manual[roman type].  For acceptable syntax, [italic type]syntax[roman type].[line break][line break]".

Section - Viewpoint

When play begins: 
	now the story viewpoint is first person plural. 

Section - Showing rooms

For printing the name of a dark room:
	say "?? (visual information unavailable)";
	rule succeeds.
	
For printing the description of a dark room:
	if the number of tagged touchable not carried objects is 0:
		say "[line break][run paragraph on]" instead;
	otherwise:
		say "[bold type]Tagged objects:[roman type] [list of tagged touchable not carried objects].[line break]" instead.
	
Rule for printing room description details: stop. 

Rule for listing nondescript items:
	do nothing.




Section - Responses

[Taking inventory, taking, removing it from, dropping, putting it on, inserting it into.]

When play begins:
	now print empty inventory rule response (A) is "Claw empty.";
	now can't take yourself rule response (A) is "ERROR: the unit cannot carry itself.";
	now can't take items out of play rule response (A) is "ERROR: item not available.";
	now can't take what you're inside rule response (A) is "ERROR: current spatial position of the unit makes it impossible to pick up [the noun].";
	now can't take what's already taken rule response (A) is "ERROR: already carrying [the noun].";
	now can't take scenery rule response (A) is "Attempt failed. Object too heavy for RCM302? Contact your sales representative for information about more powerful models.[if Lemmy talking][paragraph break]'Not sure what you're attempting to do, boss, but you can't pick that up.[throwaway]'[paragraph break][end if]";
	now can only take things rule response (A) is "ERROR: order not understood. Category mistake?";
	now can't take what's fixed in place rule response (A) is "Attempt failed. Object too heavy for RCM302? Contact your sales representative for information about more powerful models.[if Lemmy talking][paragraph break]'Not sure what you're attempting to do, boss, but you can't pick that up.[throwaway]'[paragraph break][end if]";
	now standard report taking rule response (A) is "Object picked up.[if Lemmy talking][paragraph break]'[one of]All right, boss, you've picked up [the noun][or]The mech has picked up [the noun], boss[or]Looks like we've got [the noun][at random].[throwaway]'[paragraph break][end if]";
	now can't take component parts rule response (A) is "ERROR: not an independent object.";
	now can't remove what's not inside rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't drop body parts rule response (A) is "ERROR: object not held.";
	now can't drop yourself rule response (A) is "ERROR: the RCM is not holding itself.";
	now can't drop what's already dropped rule response (A) is "ERROR: object not held.";
	now can't drop what's not held rule response (A) is "ERROR: object not held.";
	now standard report dropping rule response (A) is "Object put down.[if Lemmy talking and noun is not alison][paragraph break]'[one of]Check. You've put [the noun] back on the ground[or]The mech has dropped [the noun][or]We've put down [the noun], chief[at random].[throwaway]'[paragraph break][end if]";
	now can't put something on itself rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't put onto what's not a supporter rule response (A) is "ERROR: command presupposes existence of solid horizontal surface; not part of spatial model.";
	now concise report putting rule response (A) is "Object put down. Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]OK, looks like [the noun] [are] now on [the second noun][or]You've put [the noun] on [the second noun], boss[at random].[throwaway]'[paragraph break][end if]";
	now standard report putting rule response (A) is "Object put down. Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]OK, looks like [the noun] [are] now on [the second noun][or]You've put [the noun] on [the second noun], boss[at random].[throwaway]'[paragraph break][end if]";
	now can't insert something into itself rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't insert into closed containers rule response (A) is "Attempt failed. [Second noun] not open or not a container?[if Lemmy talking][paragraph break]'Not sure what you're attempting to do, boss, but it's closed.[throwaway]'[paragraph break][end if]";
	now can't insert into what's not a container rule response (A) is "Attempt failed. [Second noun] not open or not a container?[if Lemmy talking][paragraph break]'Not sure what you're attempting to do, boss, but you can't put stuff in there.[throwaway]'[paragraph break][end if]";
	now concise report inserting rule response (A) is "Object put down. Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]OK, looks like [the noun] [are] now in [the second noun][or]You've put [the noun] in [the second noun], boss[at random].[throwaway]'[paragraph break][end if]";
	now standard report inserting rule response (A) is "Object put down. Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]OK, looks like [the noun] [are] now in [the second noun][or]You've put [the noun] in [the second noun], boss[at random].[throwaway]'[paragraph break][end if]".
	

[Going, entering, exiting, getting off.]

When play begins:
	now can't go that way rule response (A) is "ERROR: GPS indicates movement did not happen.[if Lemmy talking and noun is not up and noun is not down][paragraph break]'[one of]Watch out, boss, there's a wall there![or]Ouch! We can't go there![or]Careful with the equipment, boss! You just bumped it into a wall.[at random]'[end if]";
	now can't go that way rule response (B) is "ERROR: GPS indicates movement did not happen.[if Lemmy talking and noun is not up and noun is not down][paragraph break]'[one of]Watch out, boss, there's a wall there![or]Ouch! We can't go there![or]Careful with the equipment, boss! You just bumped it into a wall.[at random]'[end if]";
	now can't enter what's already entered rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't enter what's already entered rule response (B) is "ERROR: command inconsistent with spatial model.";
	now can't enter what's not enterable rule response (A) is "ERROR: command inconsistent with physics model.";
	now can't enter what's not enterable rule response (B) is "ERROR: command inconsistent with physics model.";
	now can't enter what's not enterable rule response (C) is "ERROR: command inconsistent with physics model.";
	now can't enter what's not enterable rule response (D) is "ERROR: command inconsistent with physics model.";
	now can't travel in what's not a vehicle rule response (A) is "ERROR: must get off [the nonvehicle] first.";
	now can't travel in what's not a vehicle rule response (B) is "ERROR: must exit [the nonvehicle] first.";
	now can't go through undescribed doors rule response (A) is "ERROR: GPS indicates movement did not happen.";
	now can't enter closed containers rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]That's closed, boss![or]Ouch! [The noun] is closed, boss, and you just bumped the mech into it![at random]'";
	now can't enter something carried rule response (A) is "ERROR: command inconsistent with spatial model.";
	now standard report entering rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]Okay, boss. We're now on [the noun].[or]The mech just stepped onto [the noun].[at random]'[end if]";
	now standard report entering rule response (B) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]Okay, boss. We got into [the noun].[or]The mech just stepped into [the noun].[at random]'[end if]";
	now can't exit when not inside anything rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't exit closed containers rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[The cage] is closed, boss! You're just bumping into it!'[end if]";
	now standard report exiting rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]We've gotten off [the container exited from].[or]The mech just stepped off [the container exited from].[at random]'[end if]";
	now standard report exiting rule response (B) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]We've gotten out of [the container exited from].[or]The mech just stepped out of [the container exited from].[at random]'[end if]";
	now can't get off things rule response (A) is "ERROR: command inconsistent with spatial model.";
	now standard report getting off rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'[one of]We've gotten off [the container exited from].[or]The mech just stepped off [the container exited from].[at random]'[end if]".
	
The describe contents entered into rule is not listed in the report entering rulebook.
The describe room stood up into rule is not listed in the report getting off rulebook.

[Looking, examining, looking under.]

When play begins:
	now examine directions rule response (A) is "[if Lemmy talking]'[one of]Sorry boss, I don't understand what you want to examine. The camera just seems to be pointing in a random direction.[or]I'd love to tell you something useful, but the camera doesn't seem to be pointing at anything interesting.[or]I don't think there's anything there, boss. Or maybe I just don't understand what you're pointing at.[at random]'[end if]";
	now standard looking under rule response (A) is "[if Lemmy talking]'[one of]Sorry boss, I don't understand what you want to examine. The camera just seems to be pointing in a random direction.[or]I'd love to tell you something useful, but the camera doesn't seem to be pointing at anything interesting.[or]I don't think there's anything there, boss. Or maybe I just don't understand what you're pointing at.[at random]'[end if]".
	

The examine containers rule is not listed in the carry out examining rulebook.
The examine supporters rule is not listed in the carry out examining rulebook.
The examine undescribed things rule is not listed in the carry out examining rulebook.

[Opening, closing.]

When play begins:
	now can't open unless openable rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't open what's locked rule response (A) is "Successful completion of command cannot be verified.[if Lemmy talking][paragraph break]'Seems to be locked boss -- it ain't opening!'[end if]";
	now can't open what's already open rule response (A) is "ERROR: command inconsistent with spatial model.";
	now standard report opening rule response (A) is "[if Lemmy talking]'[one of]Nice, you opened [the noun].[or]The mech has just opened [the noun].[or][The noun] is now open.[at random][throwaway]'[paragraph break][end if]";
	now can't close unless openable rule response (A) is "ERROR: command inconsistent with spatial model.";
	now can't close what's already closed rule response (A) is "ERROR: command inconsistent with spatial model.";
	now standard report closing rule response (A) is "[if Lemmy talking]'[one of]All right, you closed [the noun].[or]The mech just closed [the noun].[or][The noun] is now closed.[at random][throwaway]'[paragraph break][end if]".

The reveal any newly visible interior rule is not listed in the report opening rulebook.

[Throwing it at, attacking.]

When play begins:
	now futile to throw things at inanimate objects rule response (A) is "ERROR: throwing not available on RCM3 line. Contact your sales representative for the RCM5 line of battle mechs or the RCM6 line of sports bots.";
	now block throwing at rule response (A) is "ERROR: throwing not available on RCM3 line. Contact your sales representative for the RCM5 line of battle mechs or the RCM6 line of sports bots.";

The block attacking rule is not listed in the check attacking rulebook.

[Waiting, pulling, pushing.]

When play begins:
	now standard report waiting rule response (A) is "ERROR: NULL. No command given? CPU cycles wasted.[if lemmy talking and story start is not happening and SHDescriptions is not 1 and SHDescriptions is not 2 and SHDescriptions is not 3 and SHDescriptions is not 4 and a random chance of 1 in 3 succeeds][paragraph break]'[one of]Come on, let's go![or]The mech's just standing here, doing nothing, boss.[or]Everything okay, boss?[at random]'[end if]";
	now can't pull what's fixed in place rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]That didn't budge, boss.[or]Even this mech isn't strong enough to do that, boss![at random]'[end if]";
	now can't pull scenery rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]That didn't budge, boss.[or]Even this mech isn't strong enough to do that, boss![at random]'[end if]";
	now can't pull people rule response (A) is "Successful completion of command cannot be verified.";
	now report pulling rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]The mech pulled [the noun] a bit, boss.[or]If I didn't know better, I'd think you were pulling my leg![at random]'[end if]";
	now can't push what's fixed in place rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]That didn't budge, boss.[or]Even this mech isn't strong enough to do that, boss![at random]'[end if]";
	now can't push scenery rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]That didn't budge, boss.[or]Even this mech isn't strong enough to do that, boss![at random]'[end if]";
	now can't push people rule response (A) is "Successful completion of command cannot be verified.";
	now report pushing rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of][The noun] has been pushed slightly aside, chief.[or]I think you're pushing it, boss![at random]'[end if]".

[Jumping, climbing.]

When play begins:
	now report jumping rule response (A) is "ERROR: jumping not available on RCM3 line. Contact your sales representative for the RCM1 line of My First VigiMech children's toys or the RCM6 line of sports bots.";
	now block climbing rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'[one of]The mech made some weird climbing movements in the air, boss. Was that intentional?[or]Don't know what you were trying to do, but that sure didn't work. Unless you were trying to do something pointless, obviously. Then it was a smashing success![at random]'[end if]".

[Quitting the game. Verifying the story file, switching the story transcript on, switching the story transcript off, requesting the story file version, requesting the pronouns meaning.]

When play begins:
	now quit the game rule response (A) is "Close terminal interface?";
	now verify the story file rule response (A) is "The program has verified as intact.";
	now verify the story file rule response (B) is "The program has not verified as intact, and may be corrupt.";
	now announce the pronoun meanings rule response (D) is "no pronouns are know to the mech.".

[Non-action messages]

When play begins:
	now block vaguely going rule response (A) is "ERROR: this command requires a direction.";
	now generate action rule response (B) is "ERROR: cannot resolve action.";
	now basic accessibility rule response (A) is "ERROR: command inconsistent with ontological model.[line break][run paragraph on]";
	now requested actions require persuasion rule response (A) is "ERROR: no speech capabilities available on RCM3 line. Contact your sales representative for the RCM1 line of My First VigiMech children's toys or the RCM9 line of erotic droids.";
	now can't reach inside closed containers rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'Not sure what that was supposed to be, boss, but I doubt it worked.'";
	now can't reach inside rooms rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'Not sure what that was supposed to be, boss, but I doubt it worked.'";
	now can't reach outside closed containers rule response (A) is "Successful completion of command cannot be verified.[if lemmy talking][paragraph break]'Uh, we just bumped into [the noun]. Not good.'";
	now action processing internal rule response (A) is "ERROR: confusion of level and meta-level? Ontological inconsistency.";
	now action processing internal rule response (B) is "ERROR: missing object?";
	now action processing internal rule response (C) is "ERROR: surplus object supplied?";
	now action processing internal rule response (D) is "ERROR: missing noun?[line break][run paragraph on]";
	now action processing internal rule response (E) is "ERROR: surplus noun supplied?";
	now action processing internal rule response (F) is "ERROR: missing object?";
	now action processing internal rule response (G) is "ERROR: surplus object supplied?";
	now action processing internal rule response (H) is "ERROR: missing noun?[line break][run paragraph on]";
	now action processing internal rule response (I) is "ERROR: surplus noun supplied?";
	now action processing internal rule response (J) is  "ERROR: list of commands deemed no longer valid.";
	now action processing internal rule response (K) is "ERROR: instruction failed to compute.";
	now  parser error internal rule response (A) is "ERROR: interpretation failed.[if lemmy talking][impatient remark][end if]";
	now parser error internal rule response (B) is "ERROR: interpretation failed after determining the command to ";
	now parser error internal rule response (C) is "ERROR: interpretation failed after determining the command to (go) ";
	now parser error internal rule response (D) is "ERROR: number not recognised.";
	now parser error internal rule response (E) is "ERROR: object not recognised.[if lemmy talking][impatient remark][end if]";
	now parser error internal rule response (F) is "ERROR: command incomplete?";
	now parser error internal rule response (G) is "ERROR: mech doesn't hold the object.";
	now parser error internal rule response (H) is "ERROR: cannot use multiple objects with that command.";
	now parser error internal rule response (I) is "ERROR: cannot use multiple objects twice in one command.";
	now parser error internal rule response (J) is "ERROR: linguistic model does not determine reference of ['][pronoun i6 dictionary word]['].";
	now parser error internal rule response (K) is "ERROR: ['][pronoun i6 dictionary word]['] not available for interaction.";
	now parser error internal rule response (L) is "ERROR: exception makes no sense.";
	now parser error internal rule response (M) is "ERROR: command inconsistent with ontological model.";
	now parser error internal rule response (N) is "ERROR: command unknown.[if lemmy talking][impatient remark][end if]";
	now parser error internal rule response (O) is "ERROR: term unknown.[if lemmy talking][impatient remark][end if]";
	now parser error internal rule response (P) is "ERROR: interpretation failed.";
	now parser error internal rule response (Q) is "ERROR: number inconsistent with world model.";
	now parser error internal rule response (R) is "ERROR: cannot resolve command.[if lemmy talking][impatient remark][end if]";
	now parser error internal rule response (S) is "ERROR: cannot use repetition inside an imperative.";
	now parser error internal rule response (T) is "ERROR: invalid syntax.";
	now parser error internal rule response (U) is "ERROR: no speech capabilities available on RCM3 line. Contact your sales representative for the RCM1 line of My First VigiMech children's toys or the RCM9 line of erotic droids.";
	now parser error internal rule response (V) is "ERROR: no speech capabilities available on RCM3 line. Contact your sales representative for the RCM1 line of My First VigiMech children's toys or the RCM9 line of erotic droids.";
	now parser error internal rule response (W) is "ERROR: no speech capabilities available on RCM3 line. Contact your sales representative for the RCM1 line of My First VigiMech children's toys or the RCM9 line of erotic droids.";
	now parser error internal rule response (X) is "ERROR: command not understood.[line break][run paragraph on]";
	now parser nothing error internal rule response (A) is "ERROR: no action resulted.";
	now parser nothing error internal rule response (B) is "ERROR: none available?";
	now parser nothing error internal rule response (C) is "ERROR: not a separate object?.";
	now parser nothing error internal rule response (D) is "ERROR: command inconsistent with spatial model.[if lemmy talking][paragraph break]'I can't make out what you're trying to do, boss.'";
	now parser nothing error internal rule response (E) is "ERROR: command inconsistent with spatial model.[if lemmy talking][paragraph break]'That doesn't seem to be open, boss.'";
	now parser nothing error internal rule response (F) is "ERROR: command inconsistent with spatial model.[if lemmy talking][paragraph break]'[The noun] [are] empty, boss.'";
	now parser command internal rule response (A) is "ERROR: that cannot be corrected.";
	now parser command internal rule response (B) is "ERROR: correction not possible.";
	now parser command internal rule response (C) is "ERROR: can only correct a single word.";
	now parser command internal rule response (D) is "ERROR: repetition impossible.";
	now parser clarification internal rule response (A) is "Clarification request: who do you mean, ";
	now parser clarification internal rule response (B) is "Clarification request: which do you mean, ";
	now parser clarification internal rule response (C) is "ERROR: you can only have one item here. Which?";
	now parser clarification internal rule response (D) is "Clarification request: whom do you want [if the noun is not the player][the noun] [end if]to [parser command so far]?";
	now parser clarification internal rule response (E) is "Clarification request: what do you want [if the noun is not the player][the noun] [end if]to [parser command so far]?";
	now standard implicit taking rule response (A) is "(unit first taking [the noun])[command clarification break]";
	now immediately undo rule response (A) is "ERROR: negation of causality not supported by this model.[run paragraph on][paragraph break]"


[Varying the prose]

To say throwaway:
	if a random chance of 1 in 5 succeeds:
		say " [one of]Let's hurry up, boss. I need to take a leak and I can't do that while inside this thing. Well, I [italic type]can[roman type], in a physical sense, but... you know. If [italic type]we[roman type] don't live up to certain standards of civilisation, who will?[run paragraph on][or]By the way, it's getting pretty stuffy in here.[run paragraph on][or]We're an awesome team, aren't we?[run paragraph on][or]Did you see the Citizens last night? They should kick out that goalie! What an utter knobhead.[run paragraph on][or]When this is over, I'm going for some pints in the local, I can tell you that![run paragraph on][or]What a great piece of machinery this is.[run paragraph on][or]Let's keep moving![run paragraph on][or]Let's move. The pigs can be here any minute now.[run paragraph on][or]By the way, how are the kids doing?[run paragraph on][or]Man, I love this mech![run paragraph on][or]Wait a second, I've got to sneeze.... no, it's gone again.[run paragraph on][or]Nice work.[run paragraph on][or]How's the weather back there?[run paragraph on][at random]";
	otherwise:
		say "[run paragraph on]".

To say impatient remark:
	if a random chance of 1 in 3 succeeds and story start is not happening:
		say "[paragraph break]'[one of]You gonna take much longer, guv?[run paragraph on][or]The pigs could be here real soon, boss. Let's focus.[run paragraph on][or]Let's get moving.[run paragraph on][or]We can't keep sitting on our butts, boss. Well, not metaphorically, at least. I guess you can sit on your literal butt as much as you want, as long as your metaphorical arse keeps moving, know what I mean?[run paragraph on][or]You [italic type]do[roman type] know how to operate this thing, right?[run paragraph on][at random]'[run paragraph on]";
	otherwise:
		say "[run paragraph on]".

Section - Removing most existing actions

Understand nothing as putting it on.
Understand nothing as eating.
Understand nothing as searching.
Understand nothing as consulting it about.
Understand nothing as locking it with.
Understand nothing as unlocking it with.
Understand nothing as switching on.
Understand nothing as switching off.
Understand nothing as wearing.
Understand nothing as taking off.
Understand nothing as giving it to.
Understand nothing as showing it to.
Understand nothing as waking.
Understand nothing as kissing.
Understand nothing as answering it that.
Understand nothing as telling it about.
Understand nothing as asking it about.
Understand nothing as asking it for.
Understand nothing as touching.
Understand nothing as waving.
Understand nothing as turning.
Understand nothing as pushing it to.
Understand nothing as squeezing.
Understand nothing as saying yes.
Understand nothing as saying no.
Understand nothing as burning.
Understand nothing as waking up.
Understand nothing as thinking.
Understand nothing as smelling.
Understand nothing as listening to.
Understand nothing as tasting.
Understand nothing as cutting.
Understand nothing as tying it to.
Understand nothing as drinking.
Understand nothing as saying sorry.
Understand nothing as swinging.
Understand nothing as rubbing.
Understand nothing as setting it to.
Understand nothing as waving hands.
Understand nothing as buying.
Understand nothing as climbing.
Understand nothing as sleeping.
Understand nothing as quitting the game.
[Understand nothing as saving the game.
Understand nothing as restoring the game.
Understand nothing as restarting the game.]
Understand nothing as requesting the score.
Understand nothing as preferring abbreviated room descriptions.
Understand nothing as preferring unabbreviated room descriptions.
Understand nothing as preferring sometimes abbreviated room descriptions.
Understand nothing as switching score notification on.
Understand nothing as switching score notification off.


Section - Taking inventory

[Understand "x claw" and "examine claw" as taking inventory.]

The print standard inventory rule is not listed in any rulebook. 

Carry out taking inventory (this is the new print inventory rule): 
	let item be a random thing carried by the player;
	say "The claw is holding [the item] ([weight of the item] kg).".
	
Section - Examining the player

[We have a timer running at the start of the game so that we have a good excuse to remind the player of the 'x me' command later on.]

Progress bar is a number that varies. Progress bar is 0.

Last every turn when progress bar is not 100:
	let n be a random number between 0 and 3;
	increase progress bar by n;
	if progress bar > 100, now progress bar is 100;
	if progress bar is 100:
		say "[bold type]Internal scan finished: error.[roman type] Type 'x me' for status."


Instead of examining the player:
	let item be the player;
	if the player carries at least one thing:
		now item is random thing carried by the player;
	say "* [if the player carries at least one thing]The claw is holding [the item] ([weight of the item] kg).[otherwise]Claw empty.[end if]* [if Lemmys mood is gloating or Lemmys mood is gone]Passenger compartment empty.[otherwise if Lemmys mood is dead]Passenger compartment occupied by inanimate object?[otherwise]Passenger compartment occupied.[end if]* [if the location is safe]No environmental hazards detected.[otherwise]WARNING: toxic air detected.[end if]* [if progress bar is not 100]Possible damage. Internal scan in progress: [progress bar]% complete.[otherwise]ERROR: no visual input. Scan indicates camera undamaged. Mech in darkness?[end if]"


Section - Taking

First check taking (this is the can only take one thing rule):
	if the player carries at least one thing:
		say "ERROR: claw not empty." instead.

The can't take other people rule is not listed in the check taking rulebook.

Section - Inserting

Before inserting anything into the player:
	say "ERROR: mech not meant for storage. Contact a VigiMech sales representative for an overview of your options." instead.


Section - Pushing and pulling

First before pushing (this is the cannot push held objects rule):
	if the player carries the noun:
		say "ERROR: cannot push contents of claw. (Requires optional second arm.)" instead.

First before pulling (this is the cannot pull held objects rule):
	if the player carries the noun:
		say "ERROR: cannot pull contents of claw. (Requires optional second arm.)" instead.

First before pulling (this is the cannot pull objects when claw full rule):
	if the player carries at least one thing:
		say "ERROR: claw not empty." instead.

Section - Going

First report going:
	say "Movement attempted. GPS indicates success."
	
The can't go through closed doors rule is not listed in the check going rulebook.

[Section - Entering

The convert enter door into go rule is not listed in the check entering rulebook.

Instead of entering a door:
	say "ERROR: "]


Section - Exiting a thing

Exit-nouning is an action applying to one visible thing. Understand "exit [thing]" and "leave [thing]" as exit-nouning.

Instead of exit-nouning:
	if player is in the noun:
		try exiting;
	otherwise:
		say "ERROR: command inconsistent with spatial model."


Section - Attacking

[Unblocked it, so we need something here, also for generic cases.]

Check attacking (this is the cannot attack something held rule):
	if noun is held:
		say "ERROR: cannot punch contents of claw. (Requires optional second arm.)" instead.

Report attacking (this is the generic attacking response rule):
	if Lemmy talking:
		say "Successful completion of command cannot be verified.[paragraph break]'The claw just punched into [the noun], but without too much effect.'";
	otherwise:
		say "Successful completion of command cannot be verified.".

Mech health is a number that varies. Mech health is 3.

Report attacking the player:
	unless Lemmy talking:
		say "Successful completion of command cannot be verified.";
	otherwise:
		if mech health > 0:
			now mech health is mech health minus 1;
		if mech health is 2:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Whoah, boss! Don't do that! The mech just smashed its claw against the windscreen with a massive BANG. That did [italic type]not[roman type] sound healthy!'";
		if mech health is 1:
			say "Successful completion of command cannot be verified.[paragraph break][verbose]'Bloody hell! Have you gone completely bonkers? There's cracks all over the window now! Don't. Do. That. Again!'";
			the jeez comment happens in one turn from now;
		if mech health is 0:
			if location is safe:
				say "Successful completion of command cannot be verified.[paragraph break][verbose]'Aaah! Shit, the windscreen's all broken to pieces now. There's glass everywhere! And there's blood on my arms! Fuck you, boss, I'm leaving this thing and I'm untagging [italic type]every single object[roman type]. I'll make you know how it feels to be helpless. Stupid cunt! You'll be sitting there behind your little computer, unable to do shit, while I'm off to tell Harry's boys all about this little hideout[unless player is in In front of the lab]. I'll find some way to open that door. There's gotta be some way[end if]. You fucked me over one time too many, you cunt, trying to kill me like that, and I'm gonna make you hurt until the hurt comes crawling out of the rear end of your arse. [bold type]Untag all.[roman type]'[paragraph break]";
				now Lemmys mood is gone;
				do the great untag;
				the cunt comment happens in two turns from now;
			if location is toxic:
				say "Successful completion of command cannot be verified.[paragraph break][verbose]'Aaah! Shit, the windscreen's all broken to pieces now. There's glass everywhere! And there's blood on my arms! Fuck you, boss, I'm leaving this thing and I'm untagging [italic type]every single object[roman type]. I'm gonna... Oh God, those fumes, I can't breathe... I... No! It's... ghu... ghu... ... ... hu ...";
				now Lemmys mood is dead;
	rule succeeds;

At the time when the jeez comment happens:
	if Lemmy talking and mech health is 1:
		say "'Jeez, you had me scared there for a moment, boss. I thought you were actually going to break this thing. That could [italic type]hurt[roman type] me, you know?'";

At the time when the cunt comment happens:
	if Lemmys mood is not dead and Lemmys mood is not gloating:
		say "'Cunt!'".

To do the great untag:
	repeat with item running through things:
		now item is not tagged.
		
Section - Dropping

Held-dropping is an action applying to nothing. Understand ["open claw" and ]"drop" as held-dropping.

Check held-dropping:
	if the player carries nothing:
		say "ERROR: claw empty." instead.
		
Carry out held-dropping:
	let item be a random thing carried by the player;
	try dropping item instead.
	
[Section - Taking

Understand "close claw" as a mistake ("ERROR: try using [italic type]take[roman type] instead.").]


Section - Xyzzy

Understand "xyzzy" or "say xyzzy" or "cast xyzzy" as casting xyzzy. 

Casting xyzzy is an action applying to nothing. 

Carry out casting xyzzy: 
	say "Self-destruct module not available on RCM302. Contact your sales representative for information about the benefits of more expensive models.". 

Section - Quiting

Understand "quit" and "q" as false-quitting.	

False-quitting is an action out of world.

Carry out false-quitting:
	say "You can disconnect from the mech and quit the terminal interface through the software menu ('menu')."


Section - Status

Understand "status" and "stats" as statusing.

Statusing is an action applying to nothing.

Instead of statusing:
	try examining the player.


Section - Commands

Commanding is an action applying to nothing.

Understand "syntax" and "verbs" and "commands" and "command" as commanding.

Instead of commanding:
	say "Your unit understands the following commands for object manipulation: [italic type]take, drop, put in, open, close, pull, push, punch[roman type]; the following commands for movement: [italic type]go, enter, exit[roman type]; and the following commands for information gathering: [italic type]look, examine, inventory[roman type].".

Section - Verbose

Verbosing is an action applying to nothing.

Understand "brief" and "superbrief" and "verbose" as verbosing.

Instead of verbosing:
	if Lemmy talking:
		say "ERROR: necessary linguistic competence unavailable.[paragraph break]'I'm always in verbose mode, boss! Nature of the beast.'";
	otherwise:
		say "ERROR: necessary linguistic competence unavailable.".



Chapter - Menu

Game-started is a truth state that varies. Game-started is false.

Understand "help" or "hint" or "hints" or "about" or "info" or "menu" or "manual" or "instructions" as asking for help.

Asking for help is an action out of world.

Carry out asking for help:
	 now the current menu is the Table of Options;
	 carry out the displaying activity;
	 clear the screen;
	if game-started is true:
		try looking.

[Turned off for easy testing.]	
First when play begins:
	try asking for help.
	
This is the quit the game rule:
	stop game abruptly;
	rule succeeds.

Table of Options
title					subtable (table name)		description			toggle
"[if game-started is false]Connect to Your Mech[otherwise]Return to Terminal Interface[end if]"					--		""			quit rule
"Unit Manual"					Table of Manual		""			--
"About"					--		"Terminal Interface for Models RCM301-303[line break]Version 1.4.23. © 2018 VigiMech Corporation.[paragraph break]Lead design and programming: Victor Gijsbers.[paragraph break]Quality assurance: Brian Rushton, Sam Kabo Ashwell, Mike Carletta, Viv Dunstan and Adri.[paragraph break]Bug reports and feature requests: victor@lilith.cc"		--
"Changelog"		--	"3 October 2018. After taking into account the immense pressure that the number of entries puts on competition judges, VigiMech Corporation has decided to enable saving and restoring. If you have any questions about VigiMech's countercausal techonologies, please contact your sales representative."	--
"[if game-started is true]Disconnect and [end if]Quit"	--	""	quit the game rule

Table of Manual
title	subtable (table name)	description	toggle
"Congratulations!"	--	"Congratulations on the purchase of your RCM3 labour bot! VigiMech Corporation is the world's premier manufacturer of Remote-Controlled Mechs, and the RCM3 bot will be an invaluable asset to your company. Whether used for production, construction, warehousing, rescue operations or any other industrial purpose, its ability to move large and heavy objects around is bested by no other technology that sells at comparable prices.[paragraph break][bold type]When productivity is king, trust only VigiMech![roman type]"	a rule
"Commands"	--	"Your RCM3 labour bot is equipped with an artificial intelligence system that allows it to interpret its surroundings and understand simple natural language commands. Using its built in camera, the unit will automatically identify the objects in its environment. All you have to do is tell it to, for instance, [italic type]take crate[roman type] or [italic type]open door[roman type]. In those rare instances where the artificial intelligence is unable to correctly identify an object, your on-site crew can use the tagging device.[paragraph break]Your unit understands the following commands for object manipulation: [italic type]take, drop, put in, open, close, pull, push, punch[roman type]; the following commands for movement: [italic type]go, enter, exit[roman type]; and the following commands for information gathering: [italic type]look, examine, inventory[roman type].[paragraph break]The RCM303 model also understands the secret 5-letter self-destruct command that you have been given in a sealed envelope. If this code has been compromised, please contact your local sales operative.[paragraph break][bold type]When safety is king, trust only VigiMech![roman type]"	--
"Tagging"	--	"Your RCM3 labour bot comes equipped with a tagging device that can be operated by your on-site crew from the safety of the passenger seat. The passenger can simply point the device at the object and type in its name; from there on, the artificial intelligence will take over. Audio communication between the operator (you) and the passenger should be used to double check all assignments. Remember: your on-site crew isn't as smart as you are, or they would be as rich as you are![paragraph break][bold type]Trust only yourself... and VigiMech![roman type] "	--
"The different models"	--	"The RCM301 light labour bot is primarily meant for use in non-hazardous environments such as warehouses. It can lift up to 300kg for sustained periods of time and is capable of generating a short punching force of about 5000N. The passenger compartment of the RCM301 offers no special protection.[paragraph break]The RCM302 heavy labour bot is primarily meant for use in hazardous environments such as factories and construction sites. It can lift up to 1000kg for sustained periods of time and is capable of generating a short punching force of about 20000N. The passenger compartment of the RCM302 is airtight and thus offers protection from poisonous gases, as well as from temperatures from 40K to 600K.[paragraph break]The RCM303 very heavy labour bot is primarily meant for use in extreme environments such as rescue situations and war zones. It can lift up to 2000kg for sustained periods of time and is capable of generating a short punching force of about 40000N. The passenger compartment of the RCM303 is airtight and thus offers protection from poisonous gases, as well as from temperatures from 20K to 1000K and most hand guns and assault weapons. (No guarantees; use disposable crew only.)[paragraph break]All units have been subjected to rigorous testing.[paragraph break][bold type]When safety is king, trust only VigiMech![roman type]"
"Important safety information"	--	"The RCM3 line of labour bots is not intended for use under water, in outer space or during episodes of prolonged nuclear warfare.[paragraph break]The RCM301 has been certified in accordance with norm UK-BOTN-356A to withstand forces of up to 4000N. The RCM302 has been certified in accordance with norm UK-BOTN-356C to withstand forces of up to 15000N. The RCM303 has been certified in accordance with norm UK-BOTN-356F to withstand forces of up to 30000N. VigiMech Corporation accepts no responsibility for damage sustained when these limits are exceeded, or any other damage.[paragraph break]Remember why this expensive equipment can only be controlled by you and not by your employees.[paragraph break][bold type]Trust only yourself... and VigiMech![roman type]"	--

["Legal"					--		"Your Agreement with VigiMech Corporation:

THESE TERMS AND CONDITIONS OF USE CONSTITUTE A LEGAL AGREEMENT BETWEEN YOU AND VIGIMECH CORPORATION. ('VIGIMECH', 'WE' OR 'OUR'). PLEASE READ THIS AGREEMENT ('AGREEMENT') IN ITS ENTIRETY BEFORE YOU CONTINUE TO USE THIS SOFTWARE ('THIS SOFTWARE'). BY USING THIS SOFTWARE, YOU AGREE TO BE BOUND BY THE TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, IMMEDIATELY DISCONTINUE USING THE SOFTWARE AND DELETE IT FROM ALL YOUR DEVICES. THIS DOES NOT ENTITLE YOU TO A REFUND OF YOUR MECH UNIT. (See the fine print of your contract of purchase, section 15.2.)[paragraph break]THIS SOFTWARE IS PROVIDED 'AS IS' AND VIGIMECH CORPORATION EXCLUDES TO THE FULLEST EXTENT PERMITTED BY APPLICABLE LAW ANY WARRANTY, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, SATISFACTORY QUALITY OR FITNESS FOR A PARTICULAR PURPOSE. VIGIMECH CORPORATION WILL NOT BE LIABLE FOR ANY DAMAGES OF ANY KIND ARISING FROM THE USE OF THIS SOFTWARE INCLUDING, BUT NOT LIMITED TO, DAMAGES TO THE MINERAL, VEGETABLE AND ANIMAL KINGDOMS. YOU, NOT VIGIMECH CORPORATION, ASSUME THE ENTIRE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION DUE TO YOUR USE OF THIS SOFTWARE.[paragraph break]Except as specifically stated in these Terms and Conditions of Use or elsewhere in this software, or as otherwise required by applicable law, neither VigiMech Corporation nor its directors, employees, licensors, content providers, affiliates, mechs or other representatives will be liable for damages of any kind (including, without limitation, lost profits, direct, indirect, compensatory, consequential, exemplary, special, incidental, fatal or punitive damages) arising out of your use of, your inability to use, or the performance of this software whether or not we have been advised of the possibility or necessity of such damages.[paragraph break]By using this software, you absolve VigiMech Corporation of any responsibility for curses, racial slurs, libellous remarks, or any other hurtful, illegal or otherwise inappropriate comments made by your employees or by anyone else through the unit's voice communication system.[paragraph break]No action of VigiMech Corporation, including an express written waiver or amendment, may be construed as a waiver or amendment of any of these Terms and Conditions of Use. Should any clause of these Terms and Conditions of Use be found unenforceable, VigiMech Corporation reserves the right to use its RCM5 line of battle mechs to nevertheless enforce them."			--]



Section - Testing command

After reading a command:
	if the player's command includes "*":
		say "Comment recorded[one of] (assuming that the transcript is running)[or][stopping].";
		reject the player's command. 
